static const float PI = 3.14159265f;
static const float kMmToMeters = 0.001;
static const float kMetersToMm = 1000;

static const int bokehDownsample = 2;

static const int kBoxBlurRadius = 1;

// CoC radii below this value are clamped to 0
static const float kMinCoCDiameter = 0.03 * kMmToMeters;

// CoC radii below ths value (in downsampled pixels) are ignored to reduce aliasing and improve performance
static const float kMinCoCPixels = 2 * bokehDownsample; // Old value: 2.5

// The maximum radius for the CoC in film space
static const float kCoCSearchRadius = 1 * kMmToMeters; 

// The maximum radius for the CoC in pixels
static const float kCoCDiameterPixels = 30;

// Convert from clip space to the texture space of a fullscreen quad
float2 TexCoordsFromClipS(float2 posClipS) {
	// Y needs to be negated
	return (posClipS * float2(0.5, -0.5)) + float2(0.5, 0.5);
}